/*
 * gauche/priv/typeP.h - Type-related stuff
 *
 *   Copyright (c) 2021-2025  Shiro Kawai  <shiro@acm.org>
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *   3. Neither the name of the authors nor the names of its contributors
 *      may be used to endorse or promote products derived from this
 *      software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef GAUCHE_PRIV_TYPEP_H
#define GAUCHE_PRIV_TYPEP_H

/* Some internal type mechanisms, such as type constructors.
   We expose them only through Scheme public API.

   See src/libtype.scm for the detailed explanations of those types
   and their usage. */

/* <type-constructor-meta> in Scheme.
   It inherits <class> in C level. */
typedef struct ScmTypeConstructorRec {
    ScmClass common;
    ScmObj   initializer;
    ScmObj   deconstructor;
    ScmObj   validator;
    ScmObj   subtypeP;
    ScmObj   supertypeP;
} ScmTypeConstructor;

/* <native-type> */
typedef struct ScmNativeTypeRec {
    SCM_INSTANCE_HEADER;
    ScmObj   name;
    int      (*c_of_type)(ScmObj);
    ScmObj   (*c_ref)(void*);
    void     (*c_set)(void*, ScmObj);
    ScmObj   super;
    const char *c_type_name;
    size_t   size;
    size_t   alignment;
    ScmObj   inner;
} ScmNativeType;

SCM_CLASS_DECL(Scm_NativeTypeClass);
#define SCM_CLASS_NATIVE_TYPE    (&Scm_NativeTypeClass)
#define SCM_NATIVE_TYPE(obj)     ((ScmNativeType*)(obj))
#define SCM_NATIVE_TYPE_P(obj)   (SCM_ISA(obj, SCM_CLASS_NATIVE_TYPE))

SCM_EXTERN _Bool Scm_NativePointerP(ScmNativeType*);
SCM_EXTERN ScmNativeType *Scm_NativePointerPointeeType(ScmNativeType*);

SCM_EXTERN _Bool Scm_NativeFunctionP(ScmNativeType*);
SCM_EXTERN ScmNativeType *Scm_NativeFunctionReturnType(ScmNativeType*);
SCM_EXTERN _Bool Scm_NativeFunctionVarargsP(ScmNativeType*);
SCM_EXTERN ScmObj Scm_NativeFunctionArgTypes(ScmNativeType*);

SCM_EXTERN _Bool Scm_NativeArrayP(ScmNativeType*);
SCM_EXTERN ScmNativeType *Scm_NativeArrayElementType(ScmNativeType*);
SCM_EXTERN ScmObj Scm_NativeArrayDimensions(ScmNativeType*);

#endif  /*GAUCHE_PRIV_TYPEP_H*/
